﻿using Hims.Domain.Configurations;
using Hims.Shared.EntityModels;
using Hims.Shared.UserModels;
using RestSharp;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

namespace Hims.Api.Senders
{
    /// <summary>
    /// The  WhatsAppSMSSender.
    /// </summary>
    /// <seealso cref="Hims.Api.Senders.IWhatsAppSMSSender" />
    public class WhatsAppSMSSender : IWhatsAppSMSSender
    {
        private readonly IPracticeDetailConfiguration practiceDetailConfiguration;

        public WhatsAppSMSSender(IPracticeDetailConfiguration practiceDetailConfiguration)
        {
            this.practiceDetailConfiguration = practiceDetailConfiguration;
            
        }

        /// <summary>
        /// Sends the otp asynchronous.
        /// </summary>
        /// <param name="Mobile">The mobile.</param>
        /// <param name="Otp">The otp.</param>
        /// <returns></returns>
        public async Task<bool> SendOTPAsync(string Mobile, string Otp)
        {

            var body = new WhatsAppMessageModel
            {
                PatientMobile = Mobile,
                OTPNumber = Otp
            };
            string url = "https://hims.careaxes.net/whatsAppApi/loginotp";
            var client = new RestClient(url);
            client.Timeout = -1;

            var request = new RestRequest(Method.POST);
            request.AddJsonBody(body);

            var response = await client.ExecuteAsync(request);
            if (response.IsSuccessful)
            {
                return true;
            }

            return false;


        }

        /// <summary>
        /// Sends the whats application message asynchronous.
        /// </summary>
        /// <param name="appointmentModel">The appointment model.</param>
        /// <param name="displayTime">The display time.</param>
        /// <param name="messageType">Type of the message.</param>
        /// <param name="location">The location.</param>
        /// <returns></returns>
        public async Task<bool> SendWhatsAppMessageAsync(AppointmentModel appointmentModel, string displayTime, string messageType,string location)
        {
            var body = new WhatsAppMessageModel
            {

                PatientMobile = appointmentModel.PatientMobile,
                PatientName = appointmentModel.PatientName,
                Receptionist = "CareAxes Bot",
                DoctorName = appointmentModel.ProviderName,
                AppointmentDate = appointmentModel.AppointmentDate.ToString("dd MMMM yyyy"),
                AppointmentTime = displayTime,
                BranchName = location,
                AppointmentNo = appointmentModel.AppointmentNo,
                PracticeName= this.practiceDetailConfiguration.PracticeName,
                ContactNumber = this.practiceDetailConfiguration.ContactNumber
            };

            string url = "https://hims.careaxes.net/whatsAppApi/sendTxtMsg";
            if (messageType == "has been rescheduled successfully")
            {
                url = "https://hims.careaxes.net/whatsAppApi/reshedule";

            }
            else if (messageType == "has been cancelled")
            {
                url = "https://hims.careaxes.net/whatsAppApi/Cancel";
            }
            var client = new RestClient(url);
            client.Timeout = -1;

            var request = new RestRequest(Method.POST);
            request.AddJsonBody(body);

            var response = await client.ExecuteAsync(request);
            if (response.IsSuccessful)
            {
                return true;
            }

            return false;
        }

        /// <summary>
        /// Sends the registered message.
        /// </summary>
        /// <param name="mobile">The mobile.</param>
        /// <param name="fullName">The full name.</param>
        /// <returns></returns>
        public async Task<bool> SendRegisteredMessage(string mobile, string fullName)
        {
            var body = new WhatsAppMessageModel
            {
                PatientMobile = mobile,
                PatientName = fullName,
                PracticeName = this.practiceDetailConfiguration.PracticeName
            };
            string url = "https://hims.careaxes.net/whatsAppApi/patientreg";
            var client = new RestClient(url);
            client.Timeout = -1;

            var request = new RestRequest(Method.POST);
            request.AddJsonBody(body);

            var response = await client.ExecuteAsync(request);
            if (response.IsSuccessful)
            {
                return true;
            }

            return false;
        }

        /// <summary>
        /// Sends the lab booking whats application message.
        /// </summary>
        /// <param name="mobile">The mobile.</param>
        /// <param name="fullName">The full name.</param>
        /// <param name="LabName">Name of the lab.</param>
        /// <param name="PracticeName"></param>
        /// <returns></returns>
        public async Task<bool> SendLabBookingWhatsAppMessage(string mobile, string fullName, string LabName)
        {

            var body = new WhatsAppMessageModel
            {
                PatientMobile = mobile,
                PatientName = fullName,
                LabName=LabName,
                PracticeName = this.practiceDetailConfiguration.PracticeName,
                ContactNumber = this.practiceDetailConfiguration.ContactNumber
            };
            string url = "https://hims.careaxes.net/whatsAppApi/labbooking";
            var client = new RestClient(url);
            client.Timeout = -1;

            var request = new RestRequest(Method.POST);
            request.AddJsonBody(body);

            var response = await client.ExecuteAsync(request);
            if (response.IsSuccessful)
            {
                return true;
            }

            return false;
        }

        /// <summary>
        /// Sends the lab precaution whats application message.
        /// </summary>
        /// <param name="mobile">The mobile.</param>
        /// <param name="fullName">The full name.</param>
        /// <param name="precautionMessage">The precaution message.</param>
        /// <returns></returns>
        public async Task<bool> SendLabPrecautionWhatsAppMessage(string mobile, string fullName, string precautionMessage)
        {

            var body = new WhatsAppMessageModel
            {
                PatientMobile = mobile,
                PatientName = fullName,
                Message = precautionMessage,
                PracticeName = this.practiceDetailConfiguration.PracticeName,
                ContactNumber = this.practiceDetailConfiguration.ContactNumber
            };
            string url = "https://hims.careaxes.net/whatsAppApi/sendLabPrecautions";
            var client = new RestClient(url);
            client.Timeout = -1;

            var request = new RestRequest(Method.POST);
            request.AddJsonBody(body);

            var response = await client.ExecuteAsync(request);
            if (response.IsSuccessful)
            {
                return true;
            }

            return false;
        }

        /// <summary>
        /// Sends the lab cancelling whats application message.
        /// </summary>
        /// <param name="mobile">The mobile.</param>
        /// <param name="fullName">The full name.</param>
        /// <param name="LabName">Name of the lab.</param>
        /// <param name="requisitionNumber">The requisition number.</param>
        /// <returns></returns>
        public async Task<bool> SendLabCancellingWhatsAppMessage(string mobile, string fullName, string LabName, string requisitionNumber)
        {
            var body = new WhatsAppMessageModel
            {
                PatientMobile = mobile,
                PatientName = fullName,
                LabName = LabName,
                RequisitionNumber = requisitionNumber,
                PracticeName = this.practiceDetailConfiguration.PracticeName,
                ContactNumber = this.practiceDetailConfiguration.ContactNumber
            };
            string url = "https://hims.careaxes.net/whatsAppApi/labcancel";
            var client = new RestClient(url);
            client.Timeout = -1;

            var request = new RestRequest(Method.POST);
            request.AddJsonBody(body);

            var response = await client.ExecuteAsync(request);
            if (response.IsSuccessful)
            {
                return true;
            }

            return false;
        }

        /// <summary>
        /// Sends the lab report whats application message.
        /// </summary>
        /// <param name="mobile">The mobile.</param>
        /// <param name="fullName">The full name.</param>
        /// <param name="LabName">Name of the lab.</param>
        /// <param name="labLink">The lab link.</param>
        /// <returns></returns>
        public async Task<bool> SendLabReportWhatsAppMessage(string mobile, string fullName, string LabName, string labLink)
        {
            var body = new WhatsAppMessageModel
            {
                PatientMobile = mobile,
                PatientName = fullName,
                LabName = LabName,
                LabLink = labLink,
                ContactNumber = this.practiceDetailConfiguration.ContactNumber
            };
            string url = "https://hims.careaxes.net/whatsAppApi/labreports";
            var client = new RestClient(url);
            client.Timeout = -1;

            var request = new RestRequest(Method.POST);
            request.AddJsonBody(body);

            var response = await client.ExecuteAsync(request);
            if (response.IsSuccessful)
            {
                return true;
            }

            return false;
        }

        /// <summary>
        /// Sends the scan whats application message.
        /// </summary>
        /// <param name="mobile">The mobile.</param>
        /// <param name="fullName">The full name.</param>
        /// <param name="scanName">Name of the scan.</param>
        /// <param name="scanDate">The scan date.</param>
        /// <param name="scanTime">The scan time.</param>
        /// <param name="type">The type.</param>
        /// <param name="requisitionNumber">The requisition number.</param>
        /// <returns></returns>
        public async Task<bool> SendScanWhatsAppMessage(string mobile, string fullName, string scanName,string scanDate, string scanTime, string type, string requisitionNumber)
        {
            DateTime time = Convert.ToDateTime(scanTime);
             scanTime = time.ToString("hh:mm tt");
            var body = new WhatsAppMessageModel
            {
                PatientMobile = mobile,
                PatientName = fullName,
                ScanName = scanName,
                RequisitionNumber=requisitionNumber,
                ScanDateTime = scanDate +"   " + scanTime,
                PracticeName = this.practiceDetailConfiguration.PracticeName,
                ContactNumber = this.practiceDetailConfiguration.ContactNumber
            };
            string url = "https://hims.careaxes.net/whatsAppApi/scanbooking";
            switch (type)
            {
                case "ScanBook":
                    url= "https://hims.careaxes.net/whatsAppApi/scanbooking";
                    break;
                case "ScanRescheduele":
                    url = "https://hims.careaxes.net/whatsAppApi/scanreschedule";
                    break;
                case "ScanCancel":
                    url = "https://hims.careaxes.net/whatsAppApi/scancancel";
                    body.ScanDateTime = null;
                    break;
            }
            var client = new RestClient(url);
            client.Timeout = -1;

            var request = new RestRequest(Method.POST);
            request.AddJsonBody(body);

            var response = await client.ExecuteAsync(request);
            if (response.IsSuccessful)
            {
                return true;
            }

            return false;
        }

        /// <summary>
        /// Sends the pharmacy whats application message.
        /// </summary>
        /// <param name="mobile">The mobile.</param>
        /// <param name="fullName">The full name.</param>
        /// <param name="type">The type.</param>
        /// <returns></returns>
        public bool SendPharmacyWhatsAppMessage(string mobile, string fullName, string type)
        {
            var body = new WhatsAppMessageModel
            {
                PatientMobile = mobile,
                PatientName = fullName,
                PharmacyName = "",
                ContactNumber = this.practiceDetailConfiguration.ContactNumber
            };
            string url = "https://hims.careaxes.net/whatsAppApi/pharmacysale";
            switch (type)
            {
                case "PharmacySale":
                    url = "https://hims.careaxes.net/whatsAppApi/pharmacysale";
                    break;
                case "PharmacyReturn":
                    url = "https://hims.careaxes.net/whatsAppApi/pharmacyreturn";
                    break;
            }
            var client = new RestClient(url);
            client.Timeout = -1;

            var request = new RestRequest(Method.POST);
            request.AddJsonBody(body);

            var response = client.Execute(request);
            if (response.IsSuccessful)
            {
                return true;
            }

            return false;
        }
    }
}
